/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.awt.XComboBox;
import com.sun.star.awt.XListBox;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.ui.event.UnoDataAware;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListModelBinder
implements ListDataListener {
    private XListBox unoList;
    private Object unoListModel;
    private ListModel listModel;
    private Renderer renderer = new Renderer(){

        public String render(Object object) {
            if (object == null) {
                return "";
            }
            return object.toString();
        }
    };

    public ListModelBinder(Object object, ListModel listModel) {
        this.unoList = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)object);
        this.unoListModel = UnoDataAware.getModel(object);
        this.setListModel(listModel);
    }

    public void setListModel(ListModel listModel) {
        if (this.listModel != null) {
            this.listModel.removeListDataListener(this);
        }
        this.listModel = listModel;
        this.listModel.addListDataListener(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        short[] sArray = this.getSelectedItems();
        for (short s = (short)listDataEvent.getIndex0(); s <= listDataEvent.getIndex1(); s = (short)(s + 1)) {
            this.update(s);
        }
        this.setSelectedItems(sArray);
    }

    protected void update(short s) {
        this.remove(s, s);
        this.insert(s);
    }

    protected void remove(short s, short s2) {
        this.unoList.removeItems(s, (short)(s2 - s + 1));
    }

    protected void insert(short s) {
        this.unoList.addItem(this.getItemString(s), s);
    }

    protected String getItemString(short s) {
        return this.getItemString(this.listModel.getElementAt(s));
    }

    protected String getItemString(Object object) {
        return this.renderer.render(object);
    }

    protected short[] getSelectedItems() {
        return (short[])Helper.getUnoPropertyValue(this.unoListModel, "SelectedItems");
    }

    protected void setSelectedItems(short[] sArray) {
        Helper.setUnoPropertyValue(this.unoListModel, "SelectedItems", sArray);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        for (short s = (short)listDataEvent.getIndex0(); s <= listDataEvent.getIndex1(); s = (short)(s + 1)) {
            this.insert(s);
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.remove((short)listDataEvent.getIndex0(), (short)listDataEvent.getIndex1());
    }

    public static void fillList(Object object, Object[] objectArray, Renderer renderer) {
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)object);
        Helper.setUnoPropertyValue(UnoDataAware.getModel(object), "StringItemList", new String[0]);
        for (short s = 0; s < objectArray.length; s = (short)((short)(s + 1))) {
            if (objectArray[s] == null) continue;
            xListBox.addItem(renderer != null ? renderer.render(objectArray[s]) : objectArray[s].toString(), s);
        }
    }

    public static void fillComboBox(Object object, Object[] objectArray, Renderer renderer) {
        XComboBox xComboBox = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)object);
        Helper.setUnoPropertyValue(UnoDataAware.getModel(object), "StringItemList", new String[0]);
        for (short s = 0; s < objectArray.length; s = (short)((short)(s + 1))) {
            if (objectArray[s] == null) continue;
            xComboBox.addItem(renderer != null ? renderer.render(objectArray[s]) : objectArray[s].toString(), s);
        }
    }

    public static interface Renderer {
        public String render(Object var1);
    }
}

